# ThirdPerson by Archivolt
# Ported to ES 2.0
#
# ALL CONFIGURATION IS DONE IN CONFIG.CFG
# DO NOT EDIT THIS UNLESS YOU KNOW WHAT YOU ARE DOING!!!

import es, playerlib, cfglib
info = es.AddonInfo()
info['name'] = "ThirdPerson"
info['basename'] = "thirdperson"
info['version'] = "1.0"
info['author'] = "Archivolt"
info['url'] = "http://headcrabhunter.co.nr"
info['description'] = "Allows players to go into 3rd person view while playing. Converted to ES2.0"
es.ServerVar(info['basename'], info['version'], info['description']).makepublic()

config = cfglib.AddonCFG(es.getAddonPath("thirdperson") + "/config.cfg")
config.text("******************************")
config.text("THIRDPERSON SETTINGS")
config.text("******************************")
tp_announce = config.cvar("tp_announce", 1, "At the beginning of the round, announce how to use 3rd Person? 1 = TRUE, 0 = FALSE")
tp_announcespawn = config.cvar("tp_announcespawn", 0, "When players spawn, announce how to use 3rd Person? Useful for Deathmatch. 1 = TRUE, 0 = FALSE")
tp_spawn = config.cvar("tp_spawn", 0, "When players spawn, automatically put them in 3rd person? 1 = TRUE, 0 = FALSE")
config.write()

def load():
    config.execute()
    es.regclientcmd('3rd_on', 'thirdperson/activate', 'Turn on 3rd Person!')
    es.regclientcmd('3rd_off', 'thirdperson/deactivate', 'Turn off 3rd Person!')
    es.regsaycmd('!3rdon', 'thirdperson/activate', 'Turn on 3rd Person!')
    es.regsaycmd('!3rdoff', 'thirdperson/deactivate', 'Turn off 3rd Person!')

def unload():
    es.unregclientcmd('3rd_on')
    es.unregclientcmd('3rd_off')
    es.unregsaycmd('!3rdon')
    es.unregsaycmd('!3rdoff')

def player_spawn(ev):
    # The 3 lines below are to stop a glitch
    es.delayed(.2, es.setplayerprop(ev['userid'], "CCSPlayer.baseclass.m_iObserverMode", 0))
    es.delayed(.3, es.setplayerprop(ev['userid'], "CCSPlayer.baseclass.localdata.m_Local.m_bDrawViewmodel", 1))
    es.delayed(.4, es.setplayerprop(ev['userid'], "CCSPlayer.baseclass.m_iFOV", 90))
    if tp_announcespawn > 0:
        es.tell(ev['userid'], "#multi", "#green[3RD]#default To use 3rd person view, type !3rdon. To turn off, type !3rdoff.")
        es.tell(ev['userid'], "#multi", "#green[3RD]#default Additional Console Commands: 3rd_on and 3rd_off.")
    if tp_spawn > 0:
        es.setplayerprop(ev['userid'], "CCSPlayer.baseclass.m_hObserverTarget", 0)
        es.delayed(.4, es.setplayerprop(ev['userid'], "CCSPlayer.baseclass.m_iObserverMode", 1))
        es.delayed(.5, es.setplayerprop(ev['userid'], "CCSPlayer.baseclass.localdata.m_Local.m_bDrawViewmodel", 0))
        es.delayed(.6, es.setplayerprop(ev['userid'], "CCSPlayer.baseclass.m_iFOV", 120))

def round_start(ev):
    if tp_announce > 0:
        es.msg("#multi", "#green[3RD]#default To use 3rd person view, type !3rdon. To turn off, type !3rdoff.")
        es.msg("#multi", "#green[3RD]#default Additional Console Commands: 3rd_on and 3rd_off.")

def activate():
    user = es.getcmduserid()
    es.setplayerprop(user, "CCSPlayer.baseclass.m_hObserverTarget", 0)
    es.delayed(.3, es.setplayerprop(user, "CCSPlayer.baseclass.m_iObserverMode", 1))
    es.delayed(.4, es.setplayerprop(user, "CCSPlayer.baseclass.localdata.m_Local.m_bDrawViewmodel", 0))
    es.delayed(.5, es.setplayerprop(user, "CCSPlayer.baseclass.m_iFOV", 120))

def deactivate():
    user = es.getcmduserid()
    es.delayed(.3, es.setplayerprop(user, "CCSPlayer.baseclass.m_iObserverMode", 0))
    es.delayed(.4, es.setplayerprop(user, "CCSPlayer.baseclass.localdata.m_Local.m_bDrawViewmodel", 1))
    es.delayed(.5, es.setplayerprop(user, "CCSPlayer.baseclass.m_iFOV", 90))

def player_death(ev):
    es.setplayerprop(ev['userid'], "CCSPlayer.baseclass.m_hObserverTarget", 0)
